/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientChampionsConfig {
    private static final String CONFIG_PREFIX = "gui.champions.config.";
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static int hudXOffset;
    public static int hudYOffset;
    public static int hudRange;
    public static boolean enableWailaIntegration;

    public static void bake() {
        hudXOffset = (Integer)ClientChampionsConfig.CLIENT.hudXOffset.get();
        hudYOffset = (Integer)ClientChampionsConfig.CLIENT.hudYOffset.get();
        hudRange = (Integer)ClientChampionsConfig.CLIENT.hudRange.get();
        enableWailaIntegration = (Boolean)ClientChampionsConfig.CLIENT.enableWailaIntegration.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue hudXOffset;
        public final ForgeConfigSpec.IntValue hudYOffset;
        public final ForgeConfigSpec.IntValue hudRange;
        public final ForgeConfigSpec.BooleanValue enableWailaIntegration;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("hud");
            this.hudXOffset = builder.comment("The x-offset for the champion HUD").translation("gui.champions.config.hudXOffset").defineInRange("hudXOffset", 0, -1000, 1000);
            this.hudYOffset = builder.comment("The y-offset for the champion HUD").translation("gui.champions.config.hudYOffset").defineInRange("hudYOffset", 0, -1000, 1000);
            this.hudRange = builder.comment("The distance, in blocks, from which the champion HUD can be seen").translation("gui.champions.config.hudRange").defineInRange("hudRange", 50, 0, 1000);
            this.enableWailaIntegration = builder.comment("Set to true to move the WAILA overlay underneath the champion HUD").translation("gui.champions.config.enableWailaIntegration").define("enableWailaIntegration", true);
            builder.pop();
        }
    }
}

